 ; Ŀ
 ;   Diss - make all dimensions use the Standard style.                    
 ;   Copyright 2003 by Rocket Software                                     
 ;                                                                         
 ; 
         
 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 
         
 ; Ŀ
 ;   Cvo - mark a point passed as the only argument.                       
 ; 
 (DEFUN CVO (pa rad colo / reps pa angg incr)
  (setq reps 32)
  (setq angg (/ pi 4))
  (setq incr (* 2.5 (/ pi reps)))
  (setq crad (/ rad 2))
 ; Ŀ
 ;   The main loop.                                                        
 ; 
  (repeat reps
          (setq rad (* rad 1.1))
          (setq pb (polar pa angg rad))
          (ici pb crad 16 colo)
          (setq pb (polar pa angg (- rad)))
          (ici pb crad 16 colo)
          (setq crad (* crad 0.95))
          (setq angg (+ angg incr)))
 (princ))
 ; Ŀ
 ;   Cvo end.                                                              
 ; 

 ; Ŀ
 ;   Subroutine Ici - grdraw circle maker.                                 
 ; 
 (DEFUN ICI (pa radd reps colo / angg incr pa1 pa2)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   Ici end.                                                              
 ; 

 ; Ŀ
 ;   Cvox - mark a point with twin spirals.                                
 ;   Arguments: Pa, a centrepoint.                                         
 ; 
 (DEFUN CVOX (pa / ss num enam)
  (setq rad (/ (getvar "viewsize") 200))
  (cvo pa rad 7)
  (mark pa (* rad 12) 7)
 (princ))
 ; Ŀ
 ;   Cvo end.                                                              
 ; 

 ; Ŀ
 ;   Disloc - find dimensions in a specific style.                         
 ; 
 (DEFUN C:DISLOC (/ ss num numm enam entt)
  (if (setq ss (ssget "x" '((0 . "dimension,leader"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if (= (cdr (assoc 3 entt)) "METRIC")
                      (progn
                           (if (null numm)
                               (setq numm 1)
                               (setq numm (1+ numm)))
                           (cvox (cdr (assoc 10 entt))))))))
  (if numm (prompt (strcat (itoa numm) "/" (itoa num))))
 (princ))
 ; Ŀ
 ;   Disloc end.                                                           
 ; 

 ; Ŀ
 ;   Diss.                                                                 
 ; 
 (DEFUN C:DISS (/ ss num enam entt)
  (if (setq ss (ssget "x" '((0 . "dimension,leader"))))
      (progn
           (setq num 0)
           (while (setq enam (ssname ss num))
                  (setq num (1+ num))
                  (setq entt (entget enam))
                  (if (/= "STANDARD" (cdr (assoc 3 entt)))
                      (entmod (setq entt (subst (cons 3 "standard")
                                                (assoc 3 entt) entt)))))))
 (princ))